 
IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE OBJECT_ID = OBJECT_ID(N'TRG_CONCILIACAO_CARTOES_LINX_CONCILIADOR_PEND') )
BEGIN 	
	DROP TRIGGER  TRG_CONCILIACAO_CARTOES_LINX_CONCILIADOR_PEND;
END 
GO
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Incluir registro para conciliação novamente
'Tabelas.............: 
'Dt Modificação......: 20/01/2021
'Modificação.........: 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

CREATE TRIGGER TRG_CONCILIACAO_CARTOES_LINX_CONCILIADOR_PEND ON CONCILIACAO_CARTOES_LINX_CONCILIADOR
FOR   UPDATE,DELETE 

AS  

IF EXISTS (SELECT * FROM INSERTED) 
BEGIN 



 INSERT INTO PDV_VD_TEF_PEND (CD_EMP, CD_FILIAL, CD_VD, CD_CTR,DT_CAD)
  SELECT  
		PDV_VD_TEF.CD_EMP,
		PDV_VD_TEF.CD_FILIAL,
		PDV_VD_TEF.CD_VD,
		PDV_VD_TEF.CD_CTR,
		GETDATE ()
  
  FROM  PDV_VD_TEF 
	   JOIN INSERTED CONCILIADOR ON PDV_VD_TEF.CD_FILIAL = CONCILIADOR.CD_FILIAL
														    AND ( CONVERT(bigint,PDV_VD_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) OR PDV_VD_TEF.NR_AUTORIZACAO  = CONCILIADOR.CD_AUTORIZACAO   ) 
															AND PDV_VD_TEF.QTDE_PARCELAS 	   = CONCILIADOR.NR_PARCELAS_LOJA 
															AND PDV_VD_TEF.VL_CARTAO		   = CONCILIADOR.VLR_BRUTO_LOJA
	   LEFT JOIN PDV_VD_TEF_PEND ON PDV_VD_TEF_PEND.CD_EMP    = PDV_VD_TEF.CD_EMP
							    AND PDV_VD_TEF_PEND.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
							    AND PDV_VD_TEF_PEND.CD_VD     = PDV_VD_TEF.CD_VD
							    AND PDV_VD_TEF_PEND.CD_CTR    = PDV_VD_TEF.CD_CTR
 WHERE PDV_VD_TEF.CD_EMP = 1 
   AND PDV_VD_TEF_PEND.CD_EMP IS NULL 
 
 
 
 
 
  INSERT INTO PDV_CUPOM_NAO_FISCAL_TEF_PEND (CD_EMP, CD_FILIAL, NR_COO, CD_CTR, DT_CAD)
  SELECT  
		PDV_CUPOM_NAO_FISCAL.CD_EMP,
		PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
		PDV_CUPOM_NAO_FISCAL.NR_COO  ,
		PDV_CUPOM_NAO_FISCAL.CD_CTR,
		GETDATE ()
    FROM PDV_CUPOM_NAO_FISCAL 
		 JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
		 							  AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
									  AND PDV_CUPOM_NAO_FISCAL.CD_CTR	 = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
		 JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
							    AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF

		 JOIN INSERTED CONCILIADOR ON PDV_RECBTO_TEF.CD_FILIAL	= CONCILIADOR.CD_FILIAL
								  AND ( CONVERT(bigint,PDV_RECBTO_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) OR PDV_RECBTO_TEF.NR_AUTORIZACAO			 = CONCILIADOR.CD_AUTORIZACAO   ) 
								  AND PDV_RECBTO_TEF.QTDE_PARCELAS 				  = CONCILIADOR.NR_PARCELAS_LOJA 
								  AND PDV_RECBTO_TEF.VL_CARTAO					  = CONCILIADOR.VLR_BRUTO_LOJA
		 LEFT JOIN PDV_CUPOM_NAO_FISCAL_TEF_PEND ON PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP	 = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
											    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL  = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
											    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR     = PDV_CUPOM_NAO_FISCAL.CD_CTR
												AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO      = PDV_CUPOM_NAO_FISCAL.NR_COO			  
								  
   WHERE PDV_CUPOM_NAO_FISCAL.CD_EMP = 1 
    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP IS NULL    
	
	
	
	

   DELETE FROM CONCILIACAO_CARTOES_FINAL	
     FROM INSERTED CONCILIACAO_CARTOES_LINX_CONCILIADOR 
		  JOIN CONCILIACAO_CARTOES_FINAL ON CONCILIACAO_CARTOES_LINX_CONCILIADOR.IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO	
	
	
	
	
END 	

IF EXISTS (SELECT * FROM DELETED ) 
BEGIN 

 INSERT INTO PDV_VD_TEF_PEND (CD_EMP, CD_FILIAL, CD_VD, CD_CTR,DT_CAD)
  SELECT  
		PDV_VD_TEF.CD_EMP,
		PDV_VD_TEF.CD_FILIAL,
		PDV_VD_TEF.CD_VD,
		PDV_VD_TEF.CD_CTR,
		GETDATE ()
  
  FROM  PDV_VD_TEF 
	   JOIN DELETED CONCILIADOR ON PDV_VD_TEF.CD_FILIAL = CONCILIADOR.CD_FILIAL
														    AND ( CONVERT(bigint,PDV_VD_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) OR PDV_VD_TEF.NR_AUTORIZACAO  = CONCILIADOR.CD_AUTORIZACAO   ) 
															AND PDV_VD_TEF.QTDE_PARCELAS 	   = CONCILIADOR.NR_PARCELAS_LOJA 
															AND PDV_VD_TEF.VL_CARTAO		   = CONCILIADOR.VLR_BRUTO_LOJA
	   LEFT JOIN PDV_VD_TEF_PEND ON PDV_VD_TEF_PEND.CD_EMP    = PDV_VD_TEF.CD_EMP
							    AND PDV_VD_TEF_PEND.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
							    AND PDV_VD_TEF_PEND.CD_VD     = PDV_VD_TEF.CD_VD
							    AND PDV_VD_TEF_PEND.CD_CTR    = PDV_VD_TEF.CD_CTR
 WHERE PDV_VD_TEF.CD_EMP = 1 
   AND PDV_VD_TEF_PEND.CD_EMP IS NULL 
 
 
 
  INSERT INTO PDV_CUPOM_NAO_FISCAL_TEF_PEND (CD_EMP, CD_FILIAL, NR_COO, CD_CTR, DT_CAD)
  SELECT  
		PDV_CUPOM_NAO_FISCAL.CD_EMP,
		PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
		PDV_CUPOM_NAO_FISCAL.NR_COO  ,
		PDV_CUPOM_NAO_FISCAL.CD_CTR,
		GETDATE ()
    FROM PDV_CUPOM_NAO_FISCAL 
		 JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
		 							  AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
									  AND PDV_CUPOM_NAO_FISCAL.CD_CTR	 = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
		 JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
							    AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF

		 JOIN DELETED CONCILIADOR ON PDV_RECBTO_TEF.CD_FILIAL	= CONCILIADOR.CD_FILIAL
								  AND ( CONVERT(bigint,PDV_RECBTO_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) OR PDV_RECBTO_TEF.NR_AUTORIZACAO			 = CONCILIADOR.CD_AUTORIZACAO   ) 
								  AND PDV_RECBTO_TEF.QTDE_PARCELAS 				  = CONCILIADOR.NR_PARCELAS_LOJA 
								  AND PDV_RECBTO_TEF.VL_CARTAO					  = CONCILIADOR.VLR_BRUTO_LOJA
		 LEFT JOIN PDV_CUPOM_NAO_FISCAL_TEF_PEND ON PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP	 = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
											    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL  = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
											    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR     = PDV_CUPOM_NAO_FISCAL.CD_CTR
												AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO      = PDV_CUPOM_NAO_FISCAL.NR_COO			  
								  
   WHERE PDV_CUPOM_NAO_FISCAL.CD_EMP = 1 
    AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP IS NULL
	
	
	
   DELETE FROM CONCILIACAO_CARTOES_FINAL	
     FROM DELETED CONCILIACAO_CARTOES_LINX_CONCILIADOR 
		  JOIN CONCILIACAO_CARTOES_FINAL ON CONCILIACAO_CARTOES_LINX_CONCILIADOR.IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO	
	      

END 												  
 